﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.TBIInstrumentVIAsrv;

public partial class TBI_Instruments_ServiceCheck : System.Web.UI.Page
{
    [Serializable()]
    private enum WorkFlow
    {
        Start,
        Validate,
        Display,
        Connect,
        Authenticate,
        Complete
    }

    private const string WorkFlowKeyName = "ServiceCheckWorkFlowKey";

    private WorkFlow WorkFlowProgress
    {
        get
        {
            object temp = Page.Session[WorkFlowKeyName];

            if (null == temp)
                return WorkFlow.Start;

            return (WorkFlow)temp;
        }
        set
        {
            Page.Session[WorkFlowKeyName] = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        //        string getStatus = Request.Form["GetStatus"];
        if (Request.HttpMethod == "POST")
        {
            HandlePost();
            return;
        }
        WorkFlowProgress = WorkFlow.Start;
    }

    private void HandlePost()
    {
        using (StreamReader reader = new StreamReader(Request.InputStream))
        {
            string instruction = reader.ReadToEnd();
            if (instruction == "GetStatus")
            {
                Response.Write(HandleWorkFlow());
                Response.End();
            }
        }
    }

    private string HandleWorkFlow()
    {
        string result = "";

        //DEBUG
        //result = WorkFlowProgress.ToString();
        //++WorkFlowProgress;
        //System.Threading.Thread.Sleep(1000);

        switch (WorkFlowProgress)
        {
            case WorkFlow.Start:
                result = ResetLocalVariables();
                break;
            case WorkFlow.Validate:
                result = RetrieveConfigurationAndValidate();
                break;
            case WorkFlow.Display:
                result = BuildExecutionPlan();
                break;
            case WorkFlow.Connect:
                result = OpenVIA(false);
                break;
            case WorkFlow.Authenticate:
                result = LaunchCPRS();
                break;
            case WorkFlow.Complete:
                result = OnNotifyCompletion();
                break;
        }

        return result;
    }

    private string ResetLocalVariables()
    {
        try
        {
            // Perform step work here
            WorkFlowProgress = WorkFlow.Validate;  //Next step
            return "Initializing connection to " + Helpers.getCurrentServiceToUse();
        }
        catch (Exception x)
        {
            return OnException(x);
        }
    }

    private string siteCode;
    private string providerDUZ;
    private string patientDFN;
    private string serverIP;
    private string serverPort;
    private string stationDivision;
    private string viaServiceURL;
    private int evaluationNoteId;
    private int followUpNoteId;
    private TbiServiceInterfaceClient viaClient = null;



    private string RetrieveConfigurationAndValidate()
    {
        try
        {
            // Perform step work here
            FillAllVariables();
            viaServiceURL = Helpers.GetDBConfigEntry("VIA.ServiceURL");
            //TestString("Site Code", siteCode);//we don't really care about this one
            TestString("Provider DUZ", providerDUZ);
            TestString("Patient DFN", patientDFN);
            TestString("Server IP", serverIP);
            TestString("Server Port", serverPort);
            TestString("Station Division", stationDivision);
            TestString("VIA Service URL", viaServiceURL);
            WorkFlowProgress = WorkFlow.Display;  //Next step
            return "Validated Configuration";
        }
        catch (Exception x)
        {
            return OnException(x);
        }
    }

    private void FillAllVariables()
    {
        Helpers.ExtractCPRSVariables(this, out siteCode, out providerDUZ, out patientDFN, out serverIP, out serverPort, out evaluationNoteId, out followUpNoteId);
        stationDivision = Session["StationDivision"] as string;
    }

    private void TestString(string name, string value)
    {
        if (string.IsNullOrEmpty(value))
            throw new ArgumentException(string.Format("The value '{0}' is not allowed for the '{1}' parameter.", value, name));
    }

    private string BuildExecutionPlan()
    {
        try
        {
            // Perform step work here
            FillAllVariables();
            StringBuilder result = new StringBuilder();
            result.AppendFormat("Connecting to {0} at {1}<br/>", Helpers.getCurrentServiceToUse(), Helpers.GetDBConfigEntry("VIA.ServiceURL"));
            result.AppendFormat("Provider DUZ = {0}, Patient DFN = {1}, Station Division = {2}<br/>", providerDUZ, patientDFN, stationDivision);
            result.AppendFormat("Using VistALink service at {0} on port {1}", serverIP, serverPort);
            WorkFlowProgress = WorkFlow.Connect;  //Next step
            //WorkFlowProgress = WorkFlow.Authenticate;
            return result.ToString();
        }
        catch (Exception x)
        {
            return OnException(x);
        }
    }

    private string OpenVIA(bool keepAlive)
    {
        try
        {
            // Perform step work here
            FillAllVariables();
            viaClient = VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager.CreateVIAClientFromDB();
            viaClient.Open();
            if (!keepAlive)
            {
                string version = viaClient.getVersion(GetQueryBean(true));//todo: replace with bean
                viaClient.Close();
                WorkFlowProgress = WorkFlow.Authenticate;  //Next step
                return "Opened connection to " + Helpers.getCurrentServiceToUse() + " (" + version + ")";
            }
            return "";
        }
        catch (Exception x)
        {
            return OnException(x);
        }
    }

    private queryBean GetQueryBean(bool appOnly)
    {
        queryBean result = new queryBean();
        result.criteria = "TBI_PWD";
        result.requestingApp = Helpers.GetDBConfigEntry("TBIServiceRequestingApp"); //"TBI";
        result.consumingAppToken = Helpers.GetDBConfigEntry("TBIServiceCred1");
        result.consumingAppPassword = Helpers.GetDBConfigEntry("TBIServiceCred2");
        if (appOnly)
            return result;
        result.patient = new patient() { localSiteId = stationDivision, localPid = patientDFN };//dfn
        result.provider = new provider() { loginSiteCode = stationDivision, userId = providerDUZ };//duz
        return result;
    }

    private string LaunchCPRS()
    {
        try
        {
            // Perform step work here
            string result = OpenVIA(true);//result will likely be ignored
            var bean = GetQueryBean(false);
            var person = viaClient.cprsLaunch(bean);
            TestFault(person);
            viaClient.Close();
            WorkFlowProgress = WorkFlow.Complete;  //Next step
            return "Successfully launched CPRS connection using " + Helpers.getCurrentServiceToUse();
        }
        catch (Exception x)
        {
            return OnException(x);
        }
    }
    private static void TestFault(abstractTO aTO)
    {
        if (aTO == null)
            throw new Exception("No result returned from service.");
        else if (aTO.fault != null)
            throw new Exception(aTO.fault.message);
    }

    private string OnNotifyCompletion()
    {
        return WorkFlow.Complete.ToString();
    }

    private string OnException(Exception x)
    {
        Logging.WriteLogToFile(x);
        WorkFlowProgress = WorkFlow.Complete;
        return x.Message;
    }
}